unit OrderForm;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Handles, SimpleEcoWebDemoEcoSpace;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnAddItem_Click(sender: System.Object; e: System.EventArgs);
    procedure button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
  strict protected  
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    ehItems: Borland.Eco.Handles.ExpressionHandle;
    label1: System.Web.UI.WebControls.Label;
    label2: System.Web.UI.WebControls.Label;
    label3: System.Web.UI.WebControls.Label;
    tbCustomer: System.Web.UI.WebControls.TextBox;
    tbShipTo: System.Web.UI.WebControls.TextBox;
    tbBillTo: System.Web.UI.WebControls.TextBox;
    dgItems: System.Web.UI.WebControls.DataGrid;
    label4: System.Web.UI.WebControls.Label;
    label5: System.Web.UI.WebControls.Label;
    ehOrderTotal: Borland.Eco.Handles.ExpressionHandle;
    btnAddItem: System.Web.UI.WebControls.Button;
    button1: System.Web.UI.WebControls.Button;
    Button2: System.Web.UI.WebControls.Button;
  {$ENDREGION}
  strict private
// ToDo replace Borland.Eco.Handles.EcoSpace with actual type of ecospace in project
// for fEcoSpace, get_EcoSpace and EcoSpace
    fEcoSpace: Borland.Eco.Handles.EcoSpace;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;
  public
    procedure DataBind; override;
  strict protected
  {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObject;
  {$ENDREGION}
  {$REGION 'DataGrid Events'}
  procedure DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider, CoreClassesUnit;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
begin
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ehItems := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.ehOrderTotal := Borland.Eco.Handles.ExpressionHandle.Create;
  Include(Self.dgItems.CancelCommand, Self.DataGrid_CancelCommand);
  Include(Self.dgItems.EditCommand, Self.DataGrid_EditCommand);
  Include(Self.dgItems.UpdateCommand, Self.DataGrid_UpdateCommand);
  Include(Self.dgItems.DeleteCommand, Self.DataGrid_DeleteCommand);
  Include(Self.btnAddItem.Click, Self.btnAddItem_Click);
  Include(Self.button1.Click, Self.button1_Click);
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(SimpleEcoWebDemoEcoSpace.TSimpleEcoWebDemoEcoSpace);
  Self.rhRoot.StaticValueTypeName := 'Order';
  // 
  // ehItems
  // 
  Self.ehItems.AddExternalId := True;
  Self.ehItems.Expression := 'self.OrderItem';
  Self.ehItems.RootHandle := Self.rhRoot;
  // 
  // ehOrderTotal
  // 
  Self.ehOrderTotal.Expression := 'self.OrderItem->collect(Price*Quantity)->' +
  'sum';
  Self.ehOrderTotal.RootHandle := Self.rhRoot;
  Include(Self.Unload, Self.Page_Unload);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
var
  Id: string;
begin
  EcoSpace.Active := True;
  Id := Request.Params['RootId'];
  if Assigned(Id) and (Id <> '') then
    rhRoot.SetElement(ObjectForId(Id));
	if not IsPostBack then
    DataBind;
  // TODO: Put user code to initialize the page here
end;

procedure TWebForm1.Page_Unload(sender: System.Object; e: System.EventArgs);
begin
	DoneWithEcoSpace();
end;

procedure TWebForm1.DataBind;
begin
	ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

{$REGION 'Utility Methods'}
procedure TWebForm1.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TWebForm1.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TWebForm1.ObjectForId(Id: string): IObject;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

{$REGION 'DataGrid Events'}

// The following code is useful if the form contains a System.Web.UI.Datagrid;
// It assumes that the elementhandle acting as a datasource has
// AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"

procedure TWebForm1.DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  ToDelete: IObject;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  ToDelete := ObjectForId(Id);
	if Assigned(ToDelete) then
    ToDelete.Delete;
  UpdateDatabase;
  DataBind;
end;

procedure TWebForm1.DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := e.Item.ItemIndex;
  DataBind;
end;

procedure TWebForm1.DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  Row: TObject;
  Eh: ElementHandle;
  ColIndex: Integer;
  Col: BoundColumn;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  SourceGrid.DataBind(); // To set DataSource
  Eh := SourceGrid.DataSource as ElementHandle;
  Row := eh.RenderElement(ObjectForId(Id));
  for colIndex := 0 to SourceGrid.Columns.Count-1 do
  begin
    Col := BoundColumn(SourceGrid.Columns[colIndex]);
    if Assigned(Col) and (not Col.ReadOnly) then
      eh.SetRenderedElementProperty(row, Col.DataField, (e.Item.Cells[colIndex].Controls[0] as TextBox).Text, true);
  end;
	UpdateDatabase;
	SourceGrid.EditItemIndex := -1;
	DataBind;
end;

procedure TWebForm1.DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := -1;
  DataBind;
end;

procedure TWebForm1.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('MainForm.aspx');
end;

procedure TWebForm1.button1_Click(sender: System.Object; e: System.EventArgs);
begin
  // Three different ways of putting back value

  // This one casts down, and is probably clearest and easiest to understand
  (rhRoot.Element.AsObject as Order).Customer := tbCustomer.Text;

  // This sets the value on the abstraction created by the IBindinglist on
  // the Handle. The string  in this case is the name of the Column on the
  // RootHandle, which in this case is the same as the name on the property,
  // since AddDefaultProperties on the handle is true.
  // This is most generic, and handles conversion from text to the underlying type.
  // *** THE RECCOMENDED WAY ***
  rhRoot.SetRenderedElementProperty(rhRoot.GetList()[0], 'BillingAddress', tbBillTo.Text, true);

  // Just for completeness, set via the IElement interfaces.
  (rhRoot.Element as IObject).Properties['ShippingAddress'].AsObject
  := tbShipTo.Text;

  UpdateDatabase();
  DataBind();
end;

procedure TWebForm1.btnAddItem_Click(sender: System.Object; e: System.EventArgs);
var
  Oi: Orderitem;
begin
  Oi := OrderItem.Create(EcoSpace);
	Oi.Order := rhRoot.Element.AsObject as Order;
  Oi.Quantity := 1;
  (*
  The following line also creates a new Item in and is shorter if you don't need to
  set any other properties on the new Item.

  (ehItems.Element as IElementCollection).AddNew();
 *)
	UpdateDatabase();
	DataBind();
end;
{$ENDREGION}

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function TWebForm1.get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fecoSpace := TEcoSpaceProvider.GetEcoSpace;
		rhRoot.EcoSpace := fEcoSpace;
		// Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TWebForm1.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or it's contents here.
	// Otherwise it is not safe to return it to a pool.

  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

end.

